/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.CarriedItemTemperature;
import com.momosoftworks.coldsweat.config.type.InsulatingMount;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.core.init.TempModifierInit;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemCarryTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModDimensionTags;
import com.momosoftworks.coldsweat.data.tag.ModEffectTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import oshi.util.tuples.Triplet;

@Mod.EventBusSubscriber
public class ConfigLoadingHandler {
    private static DepthTempData DEFAULT_REGION = null;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void loadConfigs(ServerConfigsLoadedEvent event) {
        ConfigSettings.clear();
        BlockTempRegistry.flush();
        ConfigLoadingHandler.getDefaultConfigs(event.getServer());
        RegistryAccess.Frozen registries = event.getServer().m_206579_();
        ColdSweat.LOGGER.info("Loading registries from configs...");
        ConfigLoadingHandler.collectUserRegistries((RegistryAccess)registries);
        ColdSweat.LOGGER.info("Loading registries from data resources...");
        ConfigLoadingHandler.collectRegistries((RegistryAccess)registries);
        ColdSweat.LOGGER.info("Loading TOML configs...");
        ConfigSettings.load((RegistryAccess)registries, false);
        TempModifierInit.buildBlockConfigs();
        ColdSweat.LOGGER.info("Loading BlockTemps...");
        TempModifierInit.buildBlockRegistries();
    }

    public static void collectRegistries(RegistryAccess registries) {
        ConfigSettings.HEARTH_SPREAD_WHITELIST.get().addAll(((HolderSet.Named)registries.m_175515_(Registry.f_122901_).m_203431_(ModBlockTags.HEARTH_SPREAD_WHITELIST).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Adding block {} to hearth spread whitelist", holder.get());
            return (Block)holder.get();
        }).toList());
        ConfigSettings.HEARTH_SPREAD_BLACKLIST.get().addAll(((HolderSet.Named)registries.m_175515_(Registry.f_122901_).m_203431_(ModBlockTags.HEARTH_SPREAD_BLACKLIST).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Adding block {} to hearth spread blacklist", holder.get());
            return (Block)holder.get();
        }).toList());
        ConfigSettings.SLEEP_CHECK_IGNORE_BLOCKS.get().addAll(((HolderSet.Named)registries.m_175515_(Registry.f_122901_).m_203431_(ModBlockTags.IGNORE_SLEEP_CHECK).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Disabling sleeping conditions check for block {}", holder.get());
            return (Block)holder.get();
        }).toList());
        ConfigSettings.LAMP_DIMENSIONS.get(registries).addAll(((HolderSet.Named)registries.m_175515_(Registry.f_122818_).m_203431_(ModDimensionTags.SOUL_LAMP_VALID).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Enabling dimension {} for soulspring lamp", holder.m_203334_());
            return (DimensionType)holder.m_203334_();
        }).toList());
        ConfigSettings.INSULATION_BLACKLIST.get().addAll(((HolderSet.Named)registries.m_175515_(Registry.f_122904_).m_203431_(ModItemTags.NOT_INSULATABLE).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Adding item {} to insulation blacklist", holder.get());
            return (Item)holder.get();
        }).toList());
        ConfigSettings.HEARTH_POTION_BLACKLIST.get().addAll(((HolderSet.Named)registries.m_175515_(Registry.f_122900_).m_203431_(ModEffectTags.HEARTH_BLACKLISTED).orElseThrow()).m_203614_().map(holder -> {
            ColdSweat.LOGGER.info("Adding effect {} to hearth potion blacklist", holder.get());
            return (MobEffect)holder.get();
        }).toList());
        Set<Holder<InsulatorData>> insulators = registries.m_175515_(ModRegistries.INSULATOR_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<FuelData>> fuels = registries.m_175515_(ModRegistries.FUEL_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<FoodData>> foods = registries.m_175515_(ModRegistries.FOOD_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<ItemCarryTempData>> carryTemps = registries.m_175515_(ModRegistries.CARRY_TEMP_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<BlockTempData>> blockTemps = registries.m_175515_(ModRegistries.BLOCK_TEMP_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<BiomeTempData>> biomeTemps = registries.m_175515_(ModRegistries.BIOME_TEMP_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<DimensionTempData>> dimensionTemps = registries.m_175515_(ModRegistries.DIMENSION_TEMP_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<StructureTempData>> structureTemps = registries.m_175515_(ModRegistries.STRUCTURE_TEMP_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<DepthTempData>> depthTemps = registries.m_175515_(ModRegistries.DEPTH_TEMP_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<MountData>> mounts = registries.m_175515_(ModRegistries.MOUNT_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<SpawnBiomeData>> spawnBiomes = registries.m_175515_(ModRegistries.ENTITY_SPAWN_BIOME_DATA).m_203611_().collect(Collectors.toSet());
        Set<Holder<EntityTempData>> entityTemps = registries.m_175515_(ModRegistries.ENTITY_TEMP_DATA).m_203611_().collect(Collectors.toSet());
        ConfigLoadingHandler.logAndAddRegistries(registries, insulators, fuels, foods, carryTemps, blockTemps, biomeTemps, dimensionTemps, structureTemps, depthTemps, mounts, spawnBiomes, entityTemps);
    }

    public static void collectUserRegistries(RegistryAccess registries) {
        if (registries == null) {
            ColdSweat.LOGGER.error("Failed to load registries from null RegistryAccess");
            return;
        }
        HashSet<Holder<InsulatorData>> insulators = new HashSet<Holder<InsulatorData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.INSULATOR_DATA, InsulatorData.CODEC));
        HashSet<Holder<FuelData>> fuels = new HashSet<Holder<FuelData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.FUEL_DATA, FuelData.CODEC));
        HashSet<Holder<FoodData>> foods = new HashSet<Holder<FoodData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.FOOD_DATA, FoodData.CODEC));
        HashSet<Holder<ItemCarryTempData>> carryTemps = new HashSet<Holder<ItemCarryTempData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.CARRY_TEMP_DATA, ItemCarryTempData.CODEC));
        HashSet<Holder<BlockTempData>> blockTemps = new HashSet<Holder<BlockTempData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.BLOCK_TEMP_DATA, BlockTempData.CODEC));
        HashSet<Holder<BiomeTempData>> biomeTemps = new HashSet<Holder<BiomeTempData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.BIOME_TEMP_DATA, BiomeTempData.CODEC));
        HashSet<Holder<DimensionTempData>> dimensionTemps = new HashSet<Holder<DimensionTempData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.DIMENSION_TEMP_DATA, DimensionTempData.CODEC));
        HashSet<Holder<StructureTempData>> structureTemps = new HashSet<Holder<StructureTempData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.STRUCTURE_TEMP_DATA, StructureTempData.CODEC));
        HashSet<Holder<DepthTempData>> depthTemps = new HashSet<Holder<DepthTempData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.DEPTH_TEMP_DATA, DepthTempData.CODEC));
        HashSet<Holder<MountData>> mounts = new HashSet<Holder<MountData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.MOUNT_DATA, MountData.CODEC));
        HashSet<Holder<SpawnBiomeData>> spawnBiomes = new HashSet<Holder<SpawnBiomeData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.ENTITY_SPAWN_BIOME_DATA, SpawnBiomeData.CODEC));
        HashSet<Holder<EntityTempData>> entityTemps = new HashSet<Holder<EntityTempData>>(ConfigLoadingHandler.parseConfigData(ModRegistries.ENTITY_TEMP_DATA, EntityTempData.CODEC));
        ConfigLoadingHandler.logAndAddRegistries(registries, insulators, fuels, foods, carryTemps, blockTemps, biomeTemps, dimensionTemps, structureTemps, depthTemps, mounts, spawnBiomes, entityTemps);
    }

    private static void logAndAddRegistries(RegistryAccess registries, Set<Holder<InsulatorData>> insulators, Set<Holder<FuelData>> fuels, Set<Holder<FoodData>> foods, Set<Holder<ItemCarryTempData>> carryTemps, Set<Holder<BlockTempData>> blockTemps, Set<Holder<BiomeTempData>> biomeTemps, Set<Holder<DimensionTempData>> dimensionTemps, Set<Holder<StructureTempData>> structureTemps, Set<Holder<DepthTempData>> depthTemps, Set<Holder<MountData>> mounts, Set<Holder<SpawnBiomeData>> spawnBiomes, Set<Holder<EntityTempData>> entityTemps) {
        ConfigLoadingHandler.addInsulatorConfigs(insulators);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulators", insulators.size()), insulators);
        ConfigLoadingHandler.addFuelConfigs(fuels);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s fuels", fuels.size()), fuels);
        ConfigLoadingHandler.addFoodConfigs(foods);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s foods", foods.size()), foods);
        ConfigLoadingHandler.addCarryTempConfigs(carryTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s carried item temperatures", carryTemps.size()), carryTemps);
        ConfigLoadingHandler.addBlockTempConfigs(blockTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s block temperatures", blockTemps.size()), blockTemps);
        ConfigLoadingHandler.addBiomeTempConfigs(biomeTemps, registries);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s biome temperatures", biomeTemps.size()), biomeTemps);
        ConfigLoadingHandler.addDimensionTempConfigs(dimensionTemps, registries);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s dimension temperatures", dimensionTemps.size()), dimensionTemps);
        ConfigLoadingHandler.addStructureTempConfigs(structureTemps, registries);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s structure temperatures", structureTemps.size()), structureTemps);
        ConfigLoadingHandler.addDepthTempConfigs(depthTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s depth temperatures", depthTemps.size()), depthTemps);
        ConfigLoadingHandler.addMountConfigs(mounts);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulated mounts", mounts.size()), mounts);
        ConfigLoadingHandler.addSpawnBiomeConfigs(spawnBiomes, registries);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity spawn biomes", spawnBiomes.size()), spawnBiomes);
        ConfigLoadingHandler.addEntityTempConfigs(entityTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity temperatures", entityTemps.size()), entityTemps);
    }

    private static void logRegistryLoaded(String message, Set<?> registry) {
        message = registry.isEmpty() ? (String)message + "." : (String)message + ":";
        ColdSweat.LOGGER.info((String)message, (Object)registry.size());
        if (registry.isEmpty()) {
            return;
        }
        for (Object entry : registry) {
            if (entry instanceof Holder) {
                Holder holder = (Holder)entry;
                ColdSweat.LOGGER.info("{}", holder.get());
                continue;
            }
            ColdSweat.LOGGER.info("{}", entry);
        }
    }

    private static void getDefaultConfigs(MinecraftServer server) {
        DEFAULT_REGION = ConfigHelper.parseResource(server.m_177941_(), new ResourceLocation("cold_sweat", "cold_sweat/world/temp_region/default.json"), DepthTempData.CODEC).orElseThrow();
    }

    private static void addInsulatorConfigs(Set<Holder<InsulatorData>> insulators) {
        insulators.forEach(holder -> {
            List<String> requiredMods;
            InsulatorData insulatorData = (InsulatorData)holder.get();
            if (insulatorData.requiredMods().isPresent() && (requiredMods = insulatorData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            AttributeModifierMap attributeModifiers = insulatorData.attributes().orElse(new AttributeModifierMap());
            Insulator insulator = new Insulator(insulatorData.insulation(), insulatorData.slot(), insulatorData.data(), insulatorData.predicate(), attributeModifiers, insulatorData.immuneTempModifiers());
            ArrayList items = new ArrayList();
            insulatorData.data().items().ifPresent(itemList -> items.addAll(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, itemList)));
            insulatorData.data().tag().ifPresent(tag -> items.addAll(ForgeRegistries.ITEMS.tags().getTag(tag).stream().toList()));
            for (Item item : items) {
                switch (insulatorData.slot()) {
                    case ITEM: {
                        ConfigSettings.INSULATION_ITEMS.get().put((Object)item, (Object)insulator);
                        break;
                    }
                    case ARMOR: {
                        ConfigSettings.INSULATING_ARMORS.get().put((Object)item, (Object)insulator);
                        break;
                    }
                    case CURIO: {
                        if (!CompatManager.isCuriosLoaded()) break;
                        ConfigSettings.INSULATING_CURIOS.get().put((Object)item, (Object)insulator);
                    }
                }
            }
        });
    }

    private static void addFuelConfigs(Set<Holder<FuelData>> fuels) {
        fuels.forEach(holder -> {
            List<String> requiredMods;
            FuelData fuelData = (FuelData)holder.get();
            if (fuelData.requiredMods().isPresent() && (requiredMods = fuelData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            FuelData.FuelType type = fuelData.type();
            ItemRequirement data = fuelData.data();
            double fuel = fuelData.fuel();
            PredicateItem predicateItem = new PredicateItem(fuel, data, EntityRequirement.NONE);
            ArrayList items = new ArrayList();
            fuelData.data().items().ifPresent(itemList -> items.addAll(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, itemList)));
            fuelData.data().tag().ifPresent(tag -> items.addAll(ForgeRegistries.ITEMS.tags().getTag(tag).stream().toList()));
            for (Item item : items) {
                switch (type) {
                    case BOILER: {
                        ConfigSettings.BOILER_FUEL.get().put((Object)item, (Object)predicateItem);
                        break;
                    }
                    case ICEBOX: {
                        ConfigSettings.ICEBOX_FUEL.get().put((Object)item, (Object)predicateItem);
                        break;
                    }
                    case HEARTH: {
                        ConfigSettings.HEARTH_FUEL.get().put((Object)item, (Object)predicateItem);
                        break;
                    }
                    case SOUL_LAMP: {
                        ConfigSettings.SOULSPRING_LAMP_FUEL.get().put((Object)item, (Object)predicateItem);
                    }
                }
            }
        });
    }

    private static void addFoodConfigs(Set<Holder<FoodData>> foods) {
        foods.forEach(holder -> {
            List<String> requiredMods;
            FoodData foodData = (FoodData)holder.get();
            if (foodData.requiredMods().isPresent() && (requiredMods = foodData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            EntityRequirement predicate = foodData.entityRequirement().orElse(EntityRequirement.NONE);
            CompoundTag extraData = null;
            if (foodData.duration().isPresent()) {
                extraData = new CompoundTag();
                extraData.m_128405_("duration", foodData.duration().get().intValue());
            }
            PredicateItem predicateItem = new PredicateItem(foodData.value(), foodData.data(), predicate, extraData);
            ArrayList items = new ArrayList();
            foodData.data().items().ifPresent(itemList -> items.addAll(RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, itemList)));
            foodData.data().tag().ifPresent(tag -> items.addAll(ForgeRegistries.ITEMS.tags().getTag(tag).stream().toList()));
            for (Item item : items) {
                ConfigSettings.FOOD_TEMPERATURES.get().put((Object)item, (Object)predicateItem);
            }
        });
    }

    private static void addCarryTempConfigs(Set<Holder<ItemCarryTempData>> carryTemps) {
        carryTemps.forEach(holder -> {
            List<String> requiredMods;
            ItemCarryTempData carryTempData = (ItemCarryTempData)holder.get();
            if (carryTempData.requiredMods().isPresent() && (requiredMods = carryTempData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            CarriedItemTemperature carriedItemTemperature = CarriedItemTemperature.createFromData(carryTempData);
            List items = CSMath.orElse(carryTempData.data().items().orElse(null), List.of(Either.left((Object)carryTempData.data().tag().orElse(null))), List.of());
            for (Item item : RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ITEMS, items)) {
                ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().put((Object)item, (Object)carriedItemTemperature);
            }
        });
    }

    private static void addBlockTempConfigs(Set<Holder<BlockTempData>> blockTemps) {
        blockTemps.forEach(holder -> {
            List<String> requiredMods;
            final BlockTempData blockTempData = (BlockTempData)holder.get();
            if (blockTempData.requiredMods().isPresent() && (requiredMods = blockTempData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            Block[] blocks = (Block[])RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.BLOCKS, blockTempData.blocks()).toArray(Block[]::new);
            BlockTemp blockTemp = new BlockTemp(blockTempData.temperature() < 0.0 ? -blockTempData.maxEffect() : -1.7976931348623157E308, blockTempData.temperature() > 0.0 ? blockTempData.maxEffect() : Double.MAX_VALUE, blockTempData.minTemp(), blockTempData.maxTemp(), blockTempData.range(), blockTempData.fade(), blocks){
                final double temperature;
                final List<BlockRequirement> conditions;
                {
                    super(minEffect, maxEffect, minTemp, maxTemp, range, fade, blocks);
                    this.temperature = blockTempData.temperature();
                    this.conditions = blockTempData.conditions();
                }

                @Override
                public double getTemperature(Level level, LivingEntity entity, BlockState state, BlockPos pos, double distance) {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < this.conditions.size(); ++i) {
                            if (this.conditions.get(i).test((Level)serverLevel, pos)) continue;
                            return 0.0;
                        }
                    }
                    return this.temperature;
                }
            };
            BlockTempRegistry.register(blockTemp);
        });
    }

    private static void addBiomeTempConfigs(Set<Holder<BiomeTempData>> biomeTemps, RegistryAccess registryAccess) {
        biomeTemps.forEach(holder -> {
            List<String> requiredMods;
            BiomeTempData biomeTempData = (BiomeTempData)holder.get();
            if (biomeTempData.requiredMods().isPresent() && (requiredMods = biomeTempData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            for (Biome biome : RegistryHelper.mapVanillaRegistryTagList(Registry.f_122885_, biomeTempData.biomes(), registryAccess)) {
                Temperature.Units units = biomeTempData.units();
                if (biomeTempData.isOffset()) {
                    ConfigSettings.BIOME_OFFSETS.get(registryAccess).put(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)Temperature.convert(biomeTempData.min(), units, Temperature.Units.MC, true), (Object)Temperature.convert(biomeTempData.max(), units, Temperature.Units.MC, true), (Object)biomeTempData.units()));
                    continue;
                }
                ConfigSettings.BIOME_TEMPS.get(registryAccess).put(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)Temperature.convert(biomeTempData.min(), units, Temperature.Units.MC, true), (Object)Temperature.convert(biomeTempData.max(), units, Temperature.Units.MC, true), (Object)biomeTempData.units()));
            }
        });
    }

    private static void addDimensionTempConfigs(Set<Holder<DimensionTempData>> dimensionTemps, RegistryAccess registryAccess) {
        dimensionTemps.forEach(holder -> {
            List<String> requiredMods;
            DimensionTempData dimensionTempData = (DimensionTempData)holder.get();
            if (dimensionTempData.requiredMods().isPresent() && (requiredMods = dimensionTempData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            for (DimensionType dimension : RegistryHelper.mapVanillaRegistryTagList(Registry.f_122818_, dimensionTempData.dimensions(), registryAccess)) {
                Temperature.Units units = dimensionTempData.units();
                if (dimensionTempData.isOffset()) {
                    ConfigSettings.DIMENSION_OFFSETS.get(registryAccess).put(dimension, (Pair<Double, Temperature.Units>)Pair.of((Object)Temperature.convert(dimensionTempData.temperature(), units, Temperature.Units.MC, true), (Object)((Object)dimensionTempData.units())));
                    continue;
                }
                ConfigSettings.DIMENSION_TEMPS.get(registryAccess).put(dimension, (Pair<Double, Temperature.Units>)Pair.of((Object)Temperature.convert(dimensionTempData.temperature(), units, Temperature.Units.MC, true), (Object)((Object)dimensionTempData.units())));
            }
        });
    }

    private static void addStructureTempConfigs(Set<Holder<StructureTempData>> structureTemps, RegistryAccess registryAccess) {
        structureTemps.forEach(holder -> {
            List<String> requiredMods;
            StructureTempData structureTempData = (StructureTempData)holder.get();
            if (structureTempData.requiredMods().isPresent() && (requiredMods = structureTempData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            for (Structure structure : RegistryHelper.mapVanillaRegistryTagList(Registry.f_235725_, structureTempData.structures(), registryAccess)) {
                double temperature = Temperature.convert(structureTempData.temperature(), structureTempData.units(), Temperature.Units.MC, !structureTempData.isOffset());
                if (structureTempData.isOffset()) {
                    ConfigSettings.STRUCTURE_OFFSETS.get(registryAccess).put(structure.m_213658_(), (Pair<Double, Temperature.Units>)Pair.of((Object)temperature, (Object)((Object)structureTempData.units())));
                    continue;
                }
                ConfigSettings.STRUCTURE_TEMPS.get(registryAccess).put(structure.m_213658_(), (Pair<Double, Temperature.Units>)Pair.of((Object)temperature, (Object)((Object)structureTempData.units())));
            }
        });
    }

    private static void addDepthTempConfigs(Set<Holder<DepthTempData>> depthTemps) {
        if (depthTemps.size() > 2 || depthTemps.stream().noneMatch(temp -> ((DepthTempData)temp.m_203334_()).equals(DEFAULT_REGION))) {
            ConfigSettings.DEPTH_REGIONS.get().remove(DEFAULT_REGION);
            depthTemps.removeIf(holder -> ((DepthTempData)holder.m_203334_()).equals(DEFAULT_REGION));
        }
        for (Holder<DepthTempData> holder2 : depthTemps) {
            List<String> requiredMods;
            DepthTempData depthTemp = (DepthTempData)holder2.m_203334_();
            if (depthTemp.requiredMods().isPresent() && (requiredMods = depthTemp.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            ConfigSettings.DEPTH_REGIONS.get().add(depthTemp);
        }
    }

    private static void addMountConfigs(Set<Holder<MountData>> mounts) {
        mounts.forEach(holder -> {
            List<String> requiredMods;
            MountData mountData = (MountData)holder.get();
            if (mountData.requiredMods().isPresent() && (requiredMods = mountData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            for (EntityType entity : RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ENTITY_TYPES, mountData.entities())) {
                ConfigSettings.INSULATED_ENTITIES.get().put((Object)entity, (Object)new InsulatingMount(entity, mountData.coldInsulation(), mountData.heatInsulation(), mountData.requirement()));
            }
        });
    }

    private static void addSpawnBiomeConfigs(Set<Holder<SpawnBiomeData>> spawnBiomes, RegistryAccess registryAccess) {
        spawnBiomes.forEach(holder -> {
            List<String> requiredMods;
            SpawnBiomeData spawnBiomeData = (SpawnBiomeData)holder.get();
            if (spawnBiomeData.requiredMods().isPresent() && (requiredMods = spawnBiomeData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            for (Biome biome : RegistryHelper.mapVanillaRegistryTagList(Registry.f_122885_, spawnBiomeData.biomes(), registryAccess)) {
                ConfigSettings.ENTITY_SPAWN_BIOMES.get(registryAccess).put((Object)biome, (Object)spawnBiomeData);
            }
        });
    }

    private static void addEntityTempConfigs(Set<Holder<EntityTempData>> entityTemps) {
        entityTemps.forEach(holder -> {
            List<String> requiredMods;
            EntityTempData entityTempData = (EntityTempData)holder.get();
            if (entityTempData.requiredMods().isPresent() && (requiredMods = entityTempData.requiredMods().get()).stream().anyMatch(mod -> !CompatManager.modLoaded(mod))) {
                return;
            }
            ArrayList types = new ArrayList();
            entityTempData.entity().type().ifPresent(type -> types.add(Either.right((Object)type)));
            entityTempData.entity().tag().ifPresent(tag -> types.add(Either.left((Object)tag)));
            for (EntityType entity : RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.ENTITY_TYPES, types)) {
                ConfigSettings.ENTITY_TEMPERATURES.get().put((Object)entity, (Object)entityTempData);
            }
        });
    }

    private static <T> Set<Holder<T>> parseConfigData(ResourceKey<Registry<T>> registry, Codec<T> codec) {
        HashSet output = new HashSet();
        Path coldSweatDataPath = FMLPaths.CONFIGDIR.get().resolve("coldsweat/data").resolve(registry.m_135782_().m_135815_());
        File jsonDirectory = coldSweatDataPath.toFile();
        if (!jsonDirectory.exists()) {
            return output;
        }
        for (File file : ConfigLoadingHandler.findFilesRecursive(jsonDirectory)) {
            if (!file.getName().endsWith(".json")) continue;
            try (FileReader reader = new FileReader(file);){
                codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_13859_((Reader)reader)).resultOrPartial(arg_0 -> ((Logger)ColdSweat.LOGGER).error(arg_0)).ifPresent(insulator -> output.add(Holder.m_205709_((Object)insulator)));
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error(String.format("Failed to parse JSON config setting in %s: %s", registry.m_135782_(), file.getName()), (Throwable)e);
            }
        }
        return output;
    }

    private static List<File> findFilesRecursive(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] filesInDirectory = directory.listFiles();
        if (filesInDirectory == null) {
            return files;
        }
        for (File file : filesInDirectory) {
            if (file.isDirectory()) {
                files.addAll(ConfigLoadingHandler.findFilesRecursive(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ClientConfigs {
        @SubscribeEvent
        public static void loadClientConfigs(FMLLoadCompleteEvent event) {
            ConfigSettings.CLIENT_SETTINGS.forEach((id, holder) -> holder.load(true));
        }
    }
}

